import numpy as np
from numpy import linalg as LA
from sklearn.datasets import load_boston
import pickle as pkl
import pandas as pd
from sklearn.linear_model import Ridge
import time

def compute_ridge_lev_score(X, reg_fac=0):
	n, d = X.shape
	G = X @ np.linalg.pinv(X.T @ X + reg_fac * np.eye(d))
	return np.sum(np.multiply(G, X), axis=1)


def max_row_norm(X):
	u = np.linalg.norm(X, axis = 1)
	return max(u)


def lamda_bound(X, m):
	n, d = X.shape
	
	if m >= d:
		return 0

	u, s, vh = np.linalg.svd(X)
	sq = np.multiply(s, s)
	lower = 0
	upper = d * max(s)
	while upper - lower > 0.1:
		mid = (upper + lower) / 2
		val = sum(np.divide(sq, sq + mid))
		if val > m:
			lower = mid
		else:
			upper = mid

	return (upper + lower) / 2


def solve_ridge_reg_via_lev(X, y, lamda, lev):
	n, d = X.shape
	p = np.minimum(lev * 200, np.ones(n))
	r = np.random.rand(n)
	z = np.squeeze(r <= p)
	clf = Ridge(lamda, fit_intercept=False)
	s = 1 / np.sqrt(p[z])
	clf.fit(X[z, :], y[z] - sum(np.divide(y[z], p[z]) / n), s)
	return clf
